import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function main() {
    console.log('Seeding bKash Auto Gateway...');

    const bkashAuto = {
        name: 'bKash Auto',
        slug: 'bkash-auto',
        type: 'AUTOMATIC',
        mode: 'TEST',
        isEnabled: false,
        image: '/gateways/bkash.png',
        currency: 'BDT',
        config: JSON.stringify({
            appKey: '',
            appSecret: '',
            username: '',
            password: '',
            baseURL: 'https://tokenized.sandbox.bka.sh/v1.2.0-beta',
            callbackURL: '/api/webhooks/bkash-auto'
        })
    };

    await prisma.paymentGateway.upsert({
        where: { slug: bkashAuto.slug },
        update: bkashAuto,
        create: bkashAuto,
    });

    console.log('bKash Auto seeded.');
}

main()
    .catch((e) => {
        console.error(e);
        process.exit(1);
    })
    .finally(async () => {
        await prisma.$disconnect();
    });
