import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

const gateways = [
    {
        name: 'Stripe',
        slug: 'stripe',
        type: 'AUTOMATIC',
        image: '/gateways/stripe.png',
        currency: 'USD',
        config: JSON.stringify({ publishableKey: '', secretKey: '' }),
    },
    {
        name: 'PayPal',
        slug: 'paypal',
        type: 'AUTOMATIC',
        image: '/gateways/paypal.png',
        currency: 'USD',
        config: JSON.stringify({ clientId: '', clientSecret: '' }),
    },
    {
        name: 'Paystack',
        slug: 'paystack',
        type: 'AUTOMATIC',
        image: '/gateways/paystack.png',
        currency: 'NGN',
        config: JSON.stringify({ publicKey: '', secretKey: '' }),
    },
    {
        name: 'Perfect Money',
        slug: 'perfect-money',
        type: 'AUTOMATIC',
        image: '/gateways/perfect-money.png',
        currency: 'USD',
        config: JSON.stringify({ accountId: '', passphrase: '' }),
    },
    {
        name: 'CoinPayments',
        slug: 'coinpayments',
        type: 'AUTOMATIC',
        image: '/gateways/coinpayments.png',
        currency: 'USD',
        config: JSON.stringify({ merchantId: '', ipnSecret: '' }),
    },
    {
        name: 'Mercado Pago',
        slug: 'mercado-pago',
        type: 'AUTOMATIC',
        image: '/gateways/mercadopago.png',
        currency: 'BRL',
        config: JSON.stringify({ accessToken: '', publicKey: '' }),
    },
    {
        name: 'Paytm',
        slug: 'paytm',
        type: 'AUTOMATIC',
        image: '/gateways/paytm.png',
        currency: 'INR',
        config: JSON.stringify({ merchantId: '', merchantKey: '' }),
    },
    {
        name: 'Instamojo',
        slug: 'instamojo',
        type: 'AUTOMATIC',
        image: '/gateways/instamojo.png',
        currency: 'INR',
        config: JSON.stringify({ apiKey: '', authToken: '' }),
    },
    {
        name: 'Razorpay',
        slug: 'razorpay',
        type: 'AUTOMATIC',
        image: '/gateways/razorpay.png',
        currency: 'INR',
        config: JSON.stringify({ keyId: '', keySecret: '' }),
    },
    {
        name: 'bKash',
        slug: 'bkash',
        type: 'MANUAL',
        image: '/gateways/bkash.png',
        currency: 'BDT',
        config: JSON.stringify({
            instructions: 'Send money to 017xxxxxxxx (Personal). Reference your email.',
            accountNumber: '01712345678',
        }),
    },
];

async function main() {
    console.log('Start seeding payment gateways...');
    for (const gateway of gateways) {
        await prisma.paymentGateway.upsert({
            where: { slug: gateway.slug },
            update: {},
            create: {
                ...gateway,
                id: await import('crypto').then(c => c.randomUUID()),
                isEnabled: false,
                mode: 'TEST',
            },
        });
        console.log(`Upserted gateway: ${gateway.name}`);
    }
    console.log('Seeding finished.');
}

main()
    .catch((e) => {
        console.error(e);
        process.exit(1);
    })
    .finally(async () => {
        await prisma.$disconnect();
    });
